
/********************************************************************************
If you should have any comments, suggestions or improvements to these samples,
we welcome you to contact us at SampleCode@melissadata.com also please visit our
developers bulletin board at forum.melissadata.com.
********************************************************************************/

using System;
using MelissaData;

namespace mdNameSample
{
    class Program
    {
      
        /*********************** LICENSE STRINGS ***********************
        *      To unlock the full functionality of Name Object,        *
        *              Or to obtain a Demo License String              *
        *   please call a sales representative at 1-800-MELISSA ext. 3 *
        *           (1-800-635-4772 x3) for a license string.          *
        *      Replace the word DEMO with your valid license string    *
        ***************************************************************/
        public static String the_license = "DEMO";
        
        public static String datafile_dir = "C:\\Program Files\\Melissa Data\\DQT\\Data";

        static void Main(string[] args)
        {
        	  String ResultsString;
            mdName nameObj = new mdName();
            if (nameObj.SetLicenseString(the_license) == 0)
            {
                Console.WriteLine("Invalid License String. To unlock full" +
                    " functionality or to obtain a Demo License String, Please call" +
                    " our representatives at 1-800-MELISSA ext3");
                Console.ReadLine();
                return;
            }

            nameObj.SetPathToNameFiles(datafile_dir);
            if (nameObj.InitializeDataFiles() != mdName.ProgramStatus.NoError)
            {
                Console.WriteLine("Error initializing mdName: " + nameObj.GetInitializeErrorString());
                Console.ReadLine();
                return;
            }

            //Get information about the object:
            Console.WriteLine();
            Console.WriteLine("======================================================="); 
            Console.WriteLine("              NAME OBJECT NET EXAMPLE           ");          
            Console.WriteLine("             Build Number: " + nameObj.GetBuildNumber());
            Console.WriteLine("            Database Date: " + nameObj.GetDatabaseDate());
            Console.WriteLine(" Database Expiration Date: " + nameObj.GetDatabaseExpirationDate());
            Console.WriteLine("  License Expiration Date: " + nameObj.GetLicenseExpirationDate());
            Console.WriteLine("=======================================================\n");             

            //Set a few processing options:
            nameObj.SetFirstNameSpellingCorrection(1);
            nameObj.SetPrimaryNameHint(mdName.NameHints.ProbablyFull);

            bool proceed = true;
            while (proceed)
            {
                //Get Name and Verify
                Console.Write("Enter Name: ");
                nameObj.SetFullName(Console.ReadLine());
                
                nameObj.Parse();
                                
                // Get the Result Codes
                ResultsString = nameObj.GetResults();
                Console.WriteLine();
                Console.WriteLine("Results...\n");
                if (ResultsString.Contains("NS01"))  
                    Console.WriteLine("NS01: There were no Errors.");
                if (ResultsString.Contains("NS03"))
                    Console.WriteLine("NS03: The spelling of the FirstName field was corrected.");
                if (ResultsString.Contains("NS04"))
                    Console.WriteLine("NS04: The spelling of the FirstName2 field was corrected.");
                
                if (ResultsString.Contains("NS02"))
                {
                    Console.WriteLine("NS02: There was an Error...");
                    if (ResultsString.Contains("NE01"))
                        Console.WriteLine("NE01: Two names were detected but the FullName string was not in a recognized format.");
                    if (ResultsString.Contains("NE02"))
                        Console.WriteLine("NE02: Multiple first names  could not accurately genderize.");

                    if (ResultsString.Contains("NE03"))
                        Console.WriteLine("NE03: A vulgarity was detected in the name.");
                    if (ResultsString.Contains("NE04"))
                        Console.WriteLine("NE04: The name contained words found on the list of nuisance names [such as Mickey Mouse].");
                    if (ResultsString.Contains("NE05"))
                        Console.WriteLine("NE05: The name contained words normally found in a company name.");
                    if (ResultsString.Contains("NE06"))
                        Console.WriteLine("NE06: The named contained a non-alphabetic character.");
                 }
                 Console.WriteLine();
                
                Console.WriteLine("      Prefix: " + nameObj.GetPrefix());
                Console.WriteLine("  First name: " + nameObj.GetFirstName());
                Console.WriteLine(" Middle Name: " + nameObj.GetMiddleName());
                Console.WriteLine("   Last Name: " + nameObj.GetLastName());
                Console.WriteLine("      Suffix: " + nameObj.GetSuffix());
                Console.WriteLine("      Gender: " + nameObj.GetGender());
                Console.WriteLine("     Prefix2: " + nameObj.GetPrefix2());
                Console.WriteLine(" First name2: " + nameObj.GetFirstName2());
                Console.WriteLine("Middle Name2: " + nameObj.GetMiddleName2());
                Console.WriteLine("  Last Name2: " + nameObj.GetLastName2());
                Console.WriteLine("     Suffix2: " + nameObj.GetSuffix2());
                Console.WriteLine("     Gender2: " + nameObj.GetGender2());
                Console.WriteLine("  Salutation: " + nameObj.GetSalutation());    
                Console.WriteLine();
                
                Console.Write("Enter X to quit:");
                string quit = Console.ReadLine();
                if (quit.ToUpper().Trim() == "X")
                {
                    proceed = false;
                }


            }
            nameObj.Dispose();
       }
    }
}
